/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.mailshare.api.IMailshare.
 */
namespace net.bluemind.mailshare.api
{

  public class MailshareClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public MailshareClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/mailshares/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>> allComplete()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_complete";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare> byEmail(String email )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_byemail";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("email", email.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.mailshare.api.Mailshare mailshare )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailshare.api.Mailshare));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, mailshare);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deletePhoto(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}/photo";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.mailshare.api.Mailshare>>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] getIcon(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/icon";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] getPhoto(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/photo";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setPhoto(String uid, byte[] arg1 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/photo";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = arg1;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.mailshare.api.Mailshare mailshare )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailshare.api.Mailshare));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, mailshare);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
