/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.mailbox.api.rules.conditions
{
  [DataContract(Namespace="")]
  public partial class MailFilterRuleFilter  {
    [DataMember]
    public List<String> fields = new List<String>();
    
    [IgnoreDataMember]
    public net.bluemind.mailbox.api.rules.conditions.MailFilterRuleOperatorName? @operator;
    [DataMember(Name = "@operator")]
    public String @operatorSurrogate
    {
        get
        {
            return @operator.HasValue ? @operator.ToString() : null;
        }
        set
        {
            net.bluemind.mailbox.api.rules.conditions.MailFilterRuleOperatorName e;
            @operator = Enum.TryParse(value, true, out e) ? e : (net.bluemind.mailbox.api.rules.conditions.MailFilterRuleOperatorName?)null;
        }
    }
    
  
  }
}
