/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.group.api.IGroup.
 */
namespace net.bluemind.group.api
{

  public class GroupClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public GroupClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/groups/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public void add(String uid, List<net.bluemind.group.api.Member> members )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}/members";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<net.bluemind.group.api.Member>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, members);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> allUids()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_alluids";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group> byEmail(String email )
    {
      String methodVerb = "GET";
      String methodPathValue = "/byEmail/{email}";
      methodPathValue = methodPathValue.Replace("{email}", HttpUtility.UrlEncode("" + email));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group> byName(String name )
    {
      String methodVerb = "GET";
      String methodPathValue = "/byName/{name}";
      methodPathValue = methodPathValue.Replace("{name}", HttpUtility.UrlEncode("" + name));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.group.api.Group group )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.group.api.Group));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, group);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void createWithExtId(String uid, String extid, net.bluemind.group.api.Group group )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}/{extid}/createwithextid";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));
      methodPathValue = methodPathValue.Replace("{extid}", HttpUtility.UrlEncode("" + extid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.group.api.Group));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, group);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.group.api.Group get(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uid);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.group.api.Group>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group> getByExtId(String extid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_extid/{extid}";
      methodPathValue = methodPathValue.Replace("{extid}", HttpUtility.UrlEncode("" + extid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.group.api.Member> getExpandedMembers(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/expandedmembers";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.group.api.Member>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.group.api.Member> getExpandedUserMembers(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/expandedusersmembers";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.group.api.Member>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> getGroupsWithRoles(List<String> roles )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_rolegroups";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, roles);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group> getLight(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/light";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.group.api.Member> getMembers(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/members";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.group.api.Member>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> getParents(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/parents";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> getRoles(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/roles";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> memberOf(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/groups";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> memberOfGroups(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/groupUids";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void remove(String uid, List<net.bluemind.group.api.Member> members )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}/members";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<net.bluemind.group.api.Member>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, members);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> search(net.bluemind.group.api.GroupSearchQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_search";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.group.api.GroupSearchQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setExtId(String uid, String arg1 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/_extId";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setRoles(String uid, List<String> roles )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/roles";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, roles);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void touch(String uid, Boolean update_vcards )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/_touch";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("update_vcards", update_vcards.ToString());

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.group.api.Group group )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.group.api.Group));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, group);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
