/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.directory.api
{
  [DataContract(Namespace="")]
  public partial class DirEntryQueryOrder  {
    [IgnoreDataMember]
    public net.bluemind.directory.api.DirEntryQueryOrderBy? by;
    [DataMember(Name = "by")]
    public String bySurrogate
    {
        get
        {
            return by.HasValue ? by.ToString() : null;
        }
        set
        {
            net.bluemind.directory.api.DirEntryQueryOrderBy e;
            by = Enum.TryParse(value, true, out e) ? e : (net.bluemind.directory.api.DirEntryQueryOrderBy?)null;
        }
    }
    
    [IgnoreDataMember]
    public net.bluemind.directory.api.DirEntryQueryDir? dir;
    [DataMember(Name = "dir")]
    public String dirSurrogate
    {
        get
        {
            return dir.HasValue ? dir.ToString() : null;
        }
        set
        {
            net.bluemind.directory.api.DirEntryQueryDir e;
            dir = Enum.TryParse(value, true, out e) ? e : (net.bluemind.directory.api.DirEntryQueryDir?)null;
        }
    }
    
  
  }
}
