/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.directory.api.IDirEntryMaintenance.
 */
namespace net.bluemind.directory.api
{

  public class DirEntryMaintenanceClient : BMClient
  {
    private String domain;
    private String entryUid;
  
    /*
     * Constructor 
     */
    public DirEntryMaintenanceClient(String baseUrl, String sid , String domain , String entryUid )
    {
      this.baseUrl = baseUrl + "/api/directory/{domain}/{entryUid}/mgmt";      
      this.sid = sid;
      this.domain = domain;
      this.baseUrl = this.baseUrl.Replace("{domain}", domain);
      this.entryUid = entryUid;
      this.baseUrl = this.baseUrl.Replace("{entryUid}", entryUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public List<net.bluemind.directory.api.MaintenanceOperation> getAvailableOperations()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_maintenance";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.directory.api.MaintenanceOperation>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef repair(net.bluemind.directory.api.RepairConfig config )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_maintenance/repair";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.directory.api.RepairConfig));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, config);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
