/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.device.api.IDevice.
 */
namespace net.bluemind.device.api
{

  public class DeviceClient : BMClient
  {
    private String userUid;
  
    /*
     * Constructor 
     */
    public DeviceClient(String baseUrl, String sid , String userUid )
    {
      this.baseUrl = baseUrl + "/api/devices/{userUid}";      
      this.sid = sid;
      this.userUid = userUid;
      this.baseUrl = this.baseUrl.Replace("{userUid}", userUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device> byIdentifier(String identifier )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{identifier}/byIdentifier";
      methodPathValue = methodPathValue.Replace("{identifier}", HttpUtility.UrlEncode("" + identifier));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.device.api.Device device )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.device.api.Device));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, device);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deleteAll()
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/_deleteAll";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>> list()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_list";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setPartnership(String uid )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}/_partnership";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void unsetPartnership(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}/_partnership";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void unwipe(String uid )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_unwipe/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.device.api.Device device )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.device.api.Device));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, device);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void updateLastSync(String uid )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/_lastSync";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void wipe(String uid, net.bluemind.device.api.WipeMode mode )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_wipe/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.device.api.WipeMode));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, mode);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
