/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.device.api
{
  [DataContract(Namespace="")]
  public partial class Device  {
    [DataMember]
    public String identifier;
    
    [DataMember]
    public String owner;
    
    [DataMember]
    public String type;
    
    [IgnoreDataMember]
    public System.DateTime? wipeDate;
    [DataMember(Name = "wipeDate")]
    public String wipeDateSurrogate
    {
      get
      {
        return (wipeDate != null)
          ? "" + Math.Floor((((DateTime)wipeDate) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          wipeDate = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          wipeDate = null;
        }
      }
    }
    
    [DataMember]
    public String wipeBy;
    
    [IgnoreDataMember]
    public System.DateTime? unwipeDate;
    [DataMember(Name = "unwipeDate")]
    public String unwipeDateSurrogate
    {
      get
      {
        return (unwipeDate != null)
          ? "" + Math.Floor((((DateTime)unwipeDate) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          unwipeDate = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          unwipeDate = null;
        }
      }
    }
    
    [DataMember]
    public String unwipeBy;
    
    [DataMember]
    public Boolean isWiped;
    
    [IgnoreDataMember]
    public net.bluemind.device.api.WipeMode? wipeMode;
    [DataMember(Name = "wipeMode")]
    public String wipeModeSurrogate
    {
        get
        {
            return wipeMode.HasValue ? wipeMode.ToString() : null;
        }
        set
        {
            net.bluemind.device.api.WipeMode e;
            wipeMode = Enum.TryParse(value, true, out e) ? e : (net.bluemind.device.api.WipeMode?)null;
        }
    }
    
    [DataMember]
    public Boolean hasPartnership;
    
    [DataMember]
    public int? policy;
    
    [IgnoreDataMember]
    public System.DateTime? lastSync;
    [DataMember(Name = "lastSync")]
    public String lastSyncSurrogate
    {
      get
      {
        return (lastSync != null)
          ? "" + Math.Floor((((DateTime)lastSync) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          lastSync = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          lastSync = null;
        }
      }
    }
    
    [DataMember]
    public double? protocolVersion;
    
  
  }
}
