/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.cti.api
{
  [DataContract(Namespace="")]
  public partial class Status  {
    [IgnoreDataMember]
    public net.bluemind.cti.api.StatusType? type;
    [DataMember(Name = "type")]
    public String typeSurrogate
    {
        get
        {
            return type.HasValue ? type.ToString() : null;
        }
        set
        {
            net.bluemind.cti.api.StatusType e;
            type = Enum.TryParse(value, true, out e) ? e : (net.bluemind.cti.api.StatusType?)null;
        }
    }
    
    [DataMember]
    public String message;
    
    [IgnoreDataMember]
    public net.bluemind.cti.api.StatusPhoneState? phoneState;
    [DataMember(Name = "phoneState")]
    public String phoneStateSurrogate
    {
        get
        {
            return phoneState.HasValue ? phoneState.ToString() : null;
        }
        set
        {
            net.bluemind.cti.api.StatusPhoneState e;
            phoneState = Enum.TryParse(value, true, out e) ? e : (net.bluemind.cti.api.StatusPhoneState?)null;
        }
    }
    
  
  }
}
