/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.core.task.api.ITask.
 */
namespace net.bluemind.core.task.api
{

  public class TaskClient : BMClient
  {
    private String taskId;
  
    /*
     * Constructor 
     */
    public TaskClient(String baseUrl, String sid , String taskId )
    {
      this.baseUrl = baseUrl + "/api/tasks/{taskId}";      
      this.sid = sid;
      this.taskId = taskId;
      this.baseUrl = this.baseUrl.Replace("{taskId}", taskId);
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public List<String> getCurrentLogs(int? offset )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_currentLogs";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("offset", offset.ToString());

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public Stream log()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_log";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Stream>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskStatus status()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskStatus>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
