/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.core.container.model
{
  [DataContract(Namespace="")]
  public partial class ContainerDescriptor : net.bluemind.core.container.model.BaseContainerDescriptor  {
    [DataMember]
    public Boolean? writable;
    
    [IgnoreDataMember]
    public List<net.bluemind.core.container.model.acl.Verb> verbs = new List<net.bluemind.core.container.model.acl.Verb>();
    [DataMember(Name = "verbs")]
    public List<String> verbsSurrogate
    {
        get
        {
            return verbs == null ? null : verbs.Select(v => v.ToString()).ToList();
        }
        set
        {
            verbs = new List<net.bluemind.core.container.model.acl.Verb>();
            foreach (string s in value)
            {
                net.bluemind.core.container.model.acl.Verb e;
                if (Enum.TryParse(s, true, out e))
                {
                    verbs.Add(e);
                }
            }            
        }
    }
    
    [DataMember]
    public Boolean offlineSync;
    
    [DataMember]
    public Boolean automount;
    
  
  }
}
