/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.core.container.api
{
  [DataContract(Namespace="")]
  public partial class ContainerQuery  {
    [DataMember]
    public String type;
    
    [DataMember]
    public String name;
    
    [IgnoreDataMember]
    public List<net.bluemind.core.container.model.acl.Verb> verb = new List<net.bluemind.core.container.model.acl.Verb>();
    [DataMember(Name = "verb")]
    public List<String> verbSurrogate
    {
        get
        {
            return verb == null ? null : verb.Select(v => v.ToString()).ToList();
        }
        set
        {
            verb = new List<net.bluemind.core.container.model.acl.Verb>();
            foreach (string s in value)
            {
                net.bluemind.core.container.model.acl.Verb e;
                if (Enum.TryParse(s, true, out e))
                {
                    verb.Add(e);
                }
            }            
        }
    }
    
    [DataMember]
    public String owner;
    
    [DataMember]
    public Boolean? @readonly;
    
    [DataMember]
    public int? size;
    
  
  }
}
