/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.core.container.api.IChangesetCleanup.
 */
namespace net.bluemind.core.container.api
{

  public class ChangesetCleanupClient : BMClient
  {
    private String serverUid;
  
    /*
     * Constructor 
     */
    public ChangesetCleanupClient(String baseUrl, String sid , String serverUid )
    {
      this.baseUrl = baseUrl + "/api/changeset_cleanup/{serverUid}";      
      this.sid = sid;
      this.serverUid = serverUid;
      this.baseUrl = this.baseUrl.Replace("{serverUid}", serverUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public void deleteOldDeletedChangesetItems(int? days )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_delete_old_changeset_items";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("days", days.ToString());

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
