/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.calendar.api.ICalendarUids.
 */
namespace net.bluemind.calendar.api
{

  public class CalendarUidsClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public CalendarUidsClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/calendar/uids";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public String getDefaultUserCalendar(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_default_calendar";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public String getResourceCalendar(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_resource_calendar";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public String getUserCreatedCalendar(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_other_calendar";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
