/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.calendar.api
{
  [DataContract(Namespace="")]
  public partial class CalendarSettingsData  {
    [IgnoreDataMember]
    public List<net.bluemind.calendar.api.CalendarSettingsDataDay> workingDays = new List<net.bluemind.calendar.api.CalendarSettingsDataDay>();
    [DataMember(Name = "workingDays")]
    public List<String> workingDaysSurrogate
    {
        get
        {
            return workingDays == null ? null : workingDays.Select(v => v.ToString()).ToList();
        }
        set
        {
            workingDays = new List<net.bluemind.calendar.api.CalendarSettingsDataDay>();
            foreach (string s in value)
            {
                net.bluemind.calendar.api.CalendarSettingsDataDay e;
                if (Enum.TryParse(s, true, out e))
                {
                    workingDays.Add(e);
                }
            }            
        }
    }
    
    [DataMember]
    public int? dayStart;
    
    [DataMember]
    public int? dayEnd;
    
    [DataMember]
    public int? minDuration;
    
    [DataMember]
    public String timezoneId;
    
  
  }
}
