/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.backend.mail.api.IOutbox.
 */
namespace net.bluemind.backend.mail.api
{

  public class OutboxClient : BMClient
  {
    private String domainUid;
    private String mailboxUid;
  
    /*
     * Constructor 
     */
    public OutboxClient(String baseUrl, String sid , String domainUid , String mailboxUid )
    {
      this.baseUrl = baseUrl + "/api/outbox/{domainUid}/{mailboxUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.mailboxUid = mailboxUid;
      this.baseUrl = this.baseUrl.Replace("{mailboxUid}", mailboxUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public net.bluemind.core.task.api.TaskRef flush()
    {
      String methodVerb = "POST";
      String methodPathValue = "/flush";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
