/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.backend.mail.api
{
  [DataContract(Namespace="")]
  public partial class MessageBodyPart  {
    [DataMember]
    public String mime;
    
    [IgnoreDataMember]
    public Dictionary<String, String> mimeParameters = new Dictionary<String, String>();
    [DataMember(Name = "mimeParameters")]
    private mimeParametersSerializer mimeParametersSurrogate
    {
        get
        {
            return new mimeParametersSerializer(mimeParameters);
        }
        set
        {
            mimeParameters = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class mimeParametersSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public mimeParametersSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public mimeParametersSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
    [DataMember]
    public String address;
    
    [DataMember]
    public String encoding;
    
    [DataMember]
    public String charset;
    
    [DataMember]
    public String fileName;
    
    [DataMember]
    public List<net.bluemind.backend.mail.api.MessageBodyHeader> headers = new List<net.bluemind.backend.mail.api.MessageBodyHeader>();
    
    [DataMember]
    public String contentId;
    
    [DataMember]
    public String hash;
    
    [DataMember]
    public List<net.bluemind.backend.mail.api.MessageBodyPart> children = new List<net.bluemind.backend.mail.api.MessageBodyPart>();
    
    [DataMember]
    public int? size;
    
    [IgnoreDataMember]
    public net.bluemind.backend.mail.api.DispositionType? dispositionType;
    [DataMember(Name = "dispositionType")]
    public String dispositionTypeSurrogate
    {
        get
        {
            return dispositionType.HasValue ? dispositionType.ToString() : null;
        }
        set
        {
            net.bluemind.backend.mail.api.DispositionType e;
            dispositionType = Enum.TryParse(value, true, out e) ? e : (net.bluemind.backend.mail.api.DispositionType?)null;
        }
    }
    
  
  }
}
