/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.backend.mail.api.IMailConversation.
 */
namespace net.bluemind.backend.mail.api
{

  public class MailConversationClient : BMClient
  {
    private String subtreeContainer;
  
    /*
     * Constructor 
     */
    public MailConversationClient(String baseUrl, String sid , String subtreeContainer )
    {
      this.baseUrl = baseUrl + "/api/mail_conversation/{subtreeContainer}";      
      this.sid = sid;
      this.subtreeContainer = subtreeContainer;
      this.baseUrl = this.baseUrl.Replace("{subtreeContainer}", subtreeContainer);
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public List<String> byFolder(String folder, net.bluemind.core.container.model.SortDescriptor sorted )
    {
      String methodVerb = "POST";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("folder", folder.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.SortDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, sorted);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.backend.mail.api.Conversation get(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.backend.mail.api.Conversation>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.backend.mail.api.Conversation> multipleGet(List<String> uids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mget";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.backend.mail.api.Conversation>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
