/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.authentication.api
{
  [DataContract(Namespace="")]
  public partial class AuthUser  {
    [DataMember]
    public String uid;
    
    [DataMember]
    public String domainUid;
    
    [DataMember]
    public String displayName;
    
    [DataMember]
    public net.bluemind.user.api.User value = new net.bluemind.user.api.User();
    
    [DataMember]
    public List<String> roles = new List<String>();
    
    [IgnoreDataMember]
    public Dictionary<String, List<String>> rolesByOU = new Dictionary<String, List<String>>();
    [DataMember(Name = "rolesByOU")]
    private rolesByOUSerializer rolesByOUSurrogate
    {
        get
        {
            return new rolesByOUSerializer(rolesByOU);
        }
        set
        {
            rolesByOU = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class rolesByOUSerializer : ISerializable
    {
        public Dictionary<String, List<String>> _data;
        public rolesByOUSerializer(Dictionary<String, List<String>> dict)
        {
            _data = dict;
        }
        public rolesByOUSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, List<String>>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = ((Object[])valueEnum.Current.Value).Cast<String>().ToList();
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
    [IgnoreDataMember]
    public Dictionary<String, String> settings = new Dictionary<String, String>();
    [DataMember(Name = "settings")]
    private settingsSerializer settingsSurrogate
    {
        get
        {
            return new settingsSerializer(settings);
        }
        set
        {
            settings = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class settingsSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public settingsSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public settingsSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
  
  }
}
