/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.addressbook.api
{
  [DataContract(Namespace="")]
  public partial class VCardIdentification  {
    [DataMember]
    public net.bluemind.addressbook.api.VCardIdentificationFormatedName formatedName = new net.bluemind.addressbook.api.VCardIdentificationFormatedName();
    
    [DataMember]
    public net.bluemind.addressbook.api.VCardIdentificationName name = new net.bluemind.addressbook.api.VCardIdentificationName();
    
    [DataMember]
    public net.bluemind.addressbook.api.VCardIdentificationNickname nickname = new net.bluemind.addressbook.api.VCardIdentificationNickname();
    
    [DataMember]
    public Boolean photo;
    
    [DataMember]
    public byte[] photoBinary;
    
    [IgnoreDataMember]
    public System.DateTime? birthday;
    [DataMember(Name = "birthday")]
    public String birthdaySurrogate
    {
      get
      {
        return (birthday != null)
          ? "" + Math.Floor((((DateTime)birthday) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          birthday = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          birthday = null;
        }
      }
    }
    
    [IgnoreDataMember]
    public System.DateTime? anniversary;
    [DataMember(Name = "anniversary")]
    public String anniversarySurrogate
    {
      get
      {
        return (anniversary != null)
          ? "" + Math.Floor((((DateTime)anniversary) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          anniversary = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          anniversary = null;
        }
      }
    }
    
    [DataMember]
    public net.bluemind.addressbook.api.VCardIdentificationGender gender = new net.bluemind.addressbook.api.VCardIdentificationGender();
    
  
  }
}
