import { downloadZip } from "client-zip";

export function createDownloadLink(href: string, name: string) {
    const link = document.createElement("a");
    link.setAttribute("download", name);
    link.setAttribute("href", href);
    link.setAttribute("target", "_blank");
    return link;
}

export async function createZipBlob(files: Array<{ filename: string; url: string }>) {
    const fetchedFiles = await Promise.all(files.map(f => fetch(encodeURI(f.url))));
    return downloadZip(fetchedFiles).blob();
}
