import { Verb } from "@bluemind/core.container.api";
import { folderUtils, mailboxUtils } from "@bluemind/mail";
const { allowConversations, allowSubfolder, allowSubfolderCreation, isDefault, translatePath } = folderUtils;
const { MailboxType } = mailboxUtils;

function fromMailboxFolder(remotefolder, mailbox, verbs) {
    const parent = remotefolder.value.parentUid;
    const path = remotefolder.value.fullName;
    const isDefaultFolder = isDefault(parent, path, remotefolder.value.name, mailbox);
    const writable = verbs.includes(Verb.Write);
    return {
        key: remotefolder.uid,
        remoteRef: {
            uid: remotefolder.uid,
            internalId: remotefolder.internalId
        },
        mailboxRef: {
            uid: mailbox.remoteRef.uid,
            key: mailbox.key
        },
        parent,
        name:
            !parent && MailboxType.isShared(mailbox.type)
                ? mailbox.name
                : isDefaultFolder
                ? translatePath(remotefolder.value.name)
                : remotefolder.value.name,
        imapName: remotefolder.value.name,
        path,
        writable: writable,
        allowConversations: allowConversations(path, mailbox),
        allowSubfolder: allowSubfolder(remotefolder.value.name, parent, path, mailbox),
        allowSubfolderCreation: allowSubfolderCreation(remotefolder.value.name, parent, path, mailbox),
        virtual: remotefolder.value.virtualFolder,
        default: isDefaultFolder,
        unread: undefined,
        hasGivenAccess: false
    };
}

function toMailboxFolder(localfolder, mailbox) {
    return {
        uid: localfolder.key || localfolder.remoteRef.uid,
        internalId: localfolder.remoteRef.internalId,
        value: {
            parentUid: localfolder.parent,
            name: localfolder.name,
            fullName: localfolder.path.replace(new RegExp("^" + mailbox.root + "/"), "")
        }
    };
}

function toRef(payload) {
    if (typeof payload === "string") {
        const uid = payload;
        return { key: uid, uid };
    } else {
        const folder = payload;
        return { key: folder.key, uid: folder.remoteRef.uid };
    }
}

export const FolderAdaptor = { fromMailboxFolder, toMailboxFolder, toRef };
