import { virtualFolderTree } from "./expandOnVirtualFolders";

describe("Toggle FOlders with virtuals ", () => {
    describe("Expand from virtual a folder", () => {
        it("If no child, return only current folder key  ", () => {
            const folders = {
                "1": { parent: null, virtual: true, key: "1" }
            };
            expect(virtualFolderTree(folders).expandFrom("1")).toEqual(new Set(["1"]));
        });

        it("expand all until non virtual value included ", () => {
            const folders = {
                "1": { parent: null, virtual: true, key: "1" },
                "2": { parent: "1", virtual: true, key: "2" },
                "3": { parent: "2", virtual: false, key: "3" },
                "4": { parent: "3", virtual: false, key: "4" }
            };
            expect(virtualFolderTree(folders).expandFrom("1")).toEqual(new Set(["1", "2"]));
        });

        it("with siblings - stop at first non virtual folder found", () => {
            const folders = {
                "1": { parent: null, virtual: true, key: "1" },
                "2": { parent: "1", virtual: false, key: "2" },
                "3": { parent: "2", virtual: false, key: "3" },
                "4": { parent: "1", virtual: false, key: "4" }
            };
            expect(virtualFolderTree(folders).expandFrom("1")).toEqual(new Set(["1"]));
        });

        it("more sibblings :more Complex example", () => {
            const folders = {
                "1": { parent: null, virtual: true, key: "1" },
                "2": { parent: "1", virtual: true, key: "2" },
                "3": { parent: "2", virtual: false, key: "3" },
                "4": { parent: "1", virtual: false, key: "4" },
                "5": { parent: "1", virtual: true, key: "5" },
                "6": { parent: "5", virtual: false, key: "6" }
            };
            expect(virtualFolderTree(folders).expandFrom("1")).toEqual(new Set(["1", "2", "5"]));
        });
    });

    describe("Which folder should receive focus ?", () => {
        it("find focus after expand", () => {
            const virtualTree = virtualFolderTree({
                "1": { parent: null, virtual: true, key: "1" },
                "2": { parent: "1", virtual: true, key: "2" },
                "3": { parent: "2", virtual: false, key: "3" },
                "4": { parent: "1", virtual: false, key: "4" },
                "5": { parent: "1", virtual: true, key: "5" },
                "6": { parent: "5", virtual: false, key: "6" }
            });

            virtualTree.expandFrom("1");
        });

        it("start in center of tree", () => {
            const virtualTree = virtualFolderTree({
                "1": { parent: null, virtual: true, key: "1" },
                "2": { parent: "1", virtual: true, key: "2" },
                "3": { parent: "2", virtual: false, key: "3" },
                "7": { parent: "3", virtual: false, key: "7" }
            });

            virtualTree.expandFrom("3");
        });

        it("Unvalid tree - focus should be null", () => {
            const virtualTree = virtualFolderTree({
                "1": { parent: null, virtual: true, key: "1" },
                "2": { parent: "1", virtual: true, key: "2" },
                "3": { parent: "2", virtual: true, key: "3" },
                "4": { parent: "1", virtual: true, key: "4" },
                "5": { parent: "1", virtual: true, key: "5" },
                "6": { parent: "5", virtual: true, key: "6" }
            });

            virtualTree.expandFrom("1");
        });
    });
});
