interface IFolder {
    parent: null | string;
    virtual: boolean;
    key: FolderID;
}

type FolderID = string;

export function virtualFolderTree(folders: Record<FolderID, IFolder>) {
    return {
        expandFrom(folderKey: FolderID): Set<FolderID> {
            return folders[folderKey].virtual
                ? new Set([folderKey, ...flatChildrenMap(folderKey, child => [...this.expandFrom(child.key)])])
                : new Set();
        }
    };
    function flatChildrenMap<U>(parentId: FolderID, callback: (value: IFolder) => U[]): U[] {
        return getChildren(parentId).flatMap(callback);
    }

    function getChildren(parentId: FolderID) {
        return Object.entries(folders).reduce((acc: Array<IFolder>, [, folder]) => {
            if (folder.parent === parentId) {
                acc.push(folder);
            }
            return acc;
        }, []);
    }
}
