import { MessageBody } from "@bluemind/backend.mail.api";
import { MimeType, PartsBuilder } from "@bluemind/email";
import i18n from "@bluemind/i18n";

export function buildForwardStructure(inlines: MessageBody.Part[] = [], attachments: MessageBody.Part[] = []) {
    normalizeAttachments(attachments);
    return withInlinesAndAttachments(inlines, attachments);
}

export function buildReplyStructure(inlines: MessageBody.Part[] = []) {
    return withInlines(inlines);
}
export function buildBasicStructure() {
    const emptyTextPart = PartsBuilder.createTextPart(null);
    const emptyHtmlPart = PartsBuilder.createHtmlPart(null);
    return PartsBuilder.createAlternativePart(emptyTextPart, emptyHtmlPart);
}
export function buildEditAsNewStructure(inlines: MessageBody.Part[] = [], attachments: MessageBody.Part[] = []) {
    return withInlinesAndAttachments(inlines, attachments);
}

function withInlines(inlines: MessageBody.Part[]) {
    let structure = buildBasicStructure();
    const images = inlines.filter(part => MimeType.isImage(part) && part.contentId);
    structure = PartsBuilder.createInlineImageParts(structure, images);
    return structure;
}

function withInlinesAndAttachments(inlines: MessageBody.Part[], attachments: MessageBody.Part[]) {
    let structure = withInlines(inlines);
    structure = PartsBuilder.createAttachmentParts(
        attachments.map(att => PartsBuilder.createAttachmentPart(att)),
        structure
    );
    return structure;
}

function normalizeAttachments(attachments: MessageBody.Part[]) {
    attachments.forEach(attachment => {
        if (!attachment.fileName) {
            attachment.fileName = i18n.global.t("mail.attachment.untitled", { mimeType: attachment.mime });
        }
    });
}
