import { computed } from "vue";
import store from "@bluemind/store";
import { MAILBOX_TRASH, MAILBOX_INBOX } from "../store/types/getters";

export default function useMoveToFolder() {
    const currentFolder = computed(() => store.state.mail.folders[store.state.mail.activeFolder]);
    const mailbox = computed(() => {
        return store.state.mail.mailboxes[currentFolder.value.mailboxRef.key];
    });

    function isValidFolder(folder: { key: string }) {
        const isCurrentFolder = currentFolder.value.key === folder?.key;
        return folder?.key && !isCurrentFolder;
    }

    function getDefaultFolders() {
        const trash = store.getters[`mail/${MAILBOX_TRASH}`](mailbox.value);
        const inbox = store.getters[`mail/${MAILBOX_INBOX}`](mailbox.value);
        return [inbox, trash].filter(isValidFolder);
    }

    return { getDefaultFolders };
}
