import { getPartDownloadUrl } from "@bluemind/email";

export default {
    props: {
        message: {
            type: Object,
            required: true
        },
        file: {
            type: Object,
            required: true
        }
    },
    computed: {
        src() {
            return (
                this.file.url ||
                getPartDownloadUrl(this.message.folderRef.uid, this.message.remoteRef.imapUid, this.file)
            );
        }
    }
};
