import { File } from "@bluemind/commons/types";
import { getFileMimeType, getFileType } from "@bluemind/commons/utils/mime-type";
import i18n from "@bluemind/i18n";

export function getFileTypeInfo(file: File): { title: string; fileType: string } {
    const fileType = getFileType(getFileMimeType(file));
    const title = i18n.global.t(`mail.content.file-type-${fileType}`);
    return { title, fileType };
}
