/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.todolist.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VTodoQueryGwtSerDer implements GwtSerDer<net.bluemind.todolist.api.VTodoQuery> {

	public VTodoQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.todolist.api.VTodoQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.todolist.api.VTodoQuery ret = new net.bluemind.todolist.api.VTodoQuery();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.todolist.api.VTodoQuery ret, JSONObject json) {
		JSONValue fromJSON = json.get("from");
		ret.from =  GwtSerDerUtils.INT.deserialize(fromJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		JSONValue queryJSON = json.get("query");
		ret.query =  GwtSerDerUtils.STRING.deserialize(queryJSON);
		JSONValue escapeQueryJSON = json.get("escapeQuery");
		ret.escapeQuery =  GwtSerDerUtils.BOOLEAN.deserialize(escapeQueryJSON);
		JSONValue todoUidJSON = json.get("todoUid");
		ret.todoUid =  GwtSerDerUtils.STRING.deserialize(todoUidJSON);
		JSONValue dateMinJSON = json.get("dateMin");
		ret.dateMin =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dateMinJSON);
		JSONValue dateMaxJSON = json.get("dateMax");
		ret.dateMax =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dateMaxJSON);
	}

	public void deserializeTo(net.bluemind.todolist.api.VTodoQuery ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("from")) {
			JSONValue fromJSON = json.get("from");
			ret.from =  GwtSerDerUtils.INT.deserialize(fromJSON);
		}
		if (!childPropertiesToIgnore.contains("size")) {
			JSONValue sizeJSON = json.get("size");
			ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		}
		if (!childPropertiesToIgnore.contains("query")) {
			JSONValue queryJSON = json.get("query");
			ret.query =  GwtSerDerUtils.STRING.deserialize(queryJSON);
		}
		if (!childPropertiesToIgnore.contains("escapeQuery")) {
			JSONValue escapeQueryJSON = json.get("escapeQuery");
			ret.escapeQuery =  GwtSerDerUtils.BOOLEAN.deserialize(escapeQueryJSON);
		}
		if (!childPropertiesToIgnore.contains("todoUid")) {
			JSONValue todoUidJSON = json.get("todoUid");
			ret.todoUid =  GwtSerDerUtils.STRING.deserialize(todoUidJSON);
		}
		if (!childPropertiesToIgnore.contains("dateMin")) {
			JSONValue dateMinJSON = json.get("dateMin");
			ret.dateMin =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dateMinJSON);
		}
		if (!childPropertiesToIgnore.contains("dateMax")) {
			JSONValue dateMaxJSON = json.get("dateMax");
			ret.dateMax =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dateMaxJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.todolist.api.VTodoQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.todolist.api.VTodoQuery o, JSONObject ret) {

		ret.put("from",  GwtSerDerUtils.INT.serialize( o.from ));
		ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		ret.put("query",  GwtSerDerUtils.STRING.serialize( o.query ));
		ret.put("escapeQuery",  GwtSerDerUtils.BOOLEAN.serialize( o.escapeQuery ));
		ret.put("todoUid",  GwtSerDerUtils.STRING.serialize( o.todoUid ));
		ret.put("dateMin",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dateMin ));
		ret.put("dateMax",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dateMax ));
	}

	public void serializeTo(net.bluemind.todolist.api.VTodoQuery o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("from")) {
			ret.put("from",  GwtSerDerUtils.INT.serialize( o.from ));
		}
		if (!childPropertiesToIgnore.contains("size")) {
			ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		}
		if (!childPropertiesToIgnore.contains("query")) {
			ret.put("query",  GwtSerDerUtils.STRING.serialize( o.query ));
		}
		if (!childPropertiesToIgnore.contains("escapeQuery")) {
			ret.put("escapeQuery",  GwtSerDerUtils.BOOLEAN.serialize( o.escapeQuery ));
		}
		if (!childPropertiesToIgnore.contains("todoUid")) {
			ret.put("todoUid",  GwtSerDerUtils.STRING.serialize( o.todoUid ));
		}
		if (!childPropertiesToIgnore.contains("dateMin")) {
			ret.put("dateMin",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dateMin ));
		}
		if (!childPropertiesToIgnore.contains("dateMax")) {
			ret.put("dateMax",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dateMax ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}