/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.todolist.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VTodoChangesGwtSerDer implements GwtSerDer<net.bluemind.todolist.api.VTodoChanges> {

	public VTodoChangesGwtSerDer( ) {
	}

	@Override
	public net.bluemind.todolist.api.VTodoChanges deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.todolist.api.VTodoChanges ret = new net.bluemind.todolist.api.VTodoChanges();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.todolist.api.VTodoChanges ret, JSONObject json) {
		JSONValue addJSON = json.get("add");
		ret.add =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoChangesItemAddGwtSerDer()).deserialize(addJSON);
		JSONValue modifyJSON = json.get("modify");
		ret.modify =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoChangesItemModifyGwtSerDer()).deserialize(modifyJSON);
		JSONValue deleteJSON = json.get("delete");
		ret.delete =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoChangesItemDeleteGwtSerDer()).deserialize(deleteJSON);
	}

	public void deserializeTo(net.bluemind.todolist.api.VTodoChanges ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("add")) {
			JSONValue addJSON = json.get("add");
			ret.add =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoChangesItemAddGwtSerDer()).deserialize(addJSON);
		}
		if (!childPropertiesToIgnore.contains("modify")) {
			JSONValue modifyJSON = json.get("modify");
			ret.modify =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoChangesItemModifyGwtSerDer()).deserialize(modifyJSON);
		}
		if (!childPropertiesToIgnore.contains("delete")) {
			JSONValue deleteJSON = json.get("delete");
			ret.delete =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoChangesItemDeleteGwtSerDer()).deserialize(deleteJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.todolist.api.VTodoChanges o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.todolist.api.VTodoChanges o, JSONObject ret) {

		ret.put("add",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoChangesItemAddGwtSerDer()).serialize( o.add ));
		ret.put("modify",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoChangesItemModifyGwtSerDer()).serialize( o.modify ));
		ret.put("delete",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoChangesItemDeleteGwtSerDer()).serialize( o.delete ));
	}

	public void serializeTo(net.bluemind.todolist.api.VTodoChanges o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("add")) {
			ret.put("add",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoChangesItemAddGwtSerDer()).serialize( o.add ));
		}
		if (!childPropertiesToIgnore.contains("modify")) {
			ret.put("modify",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoChangesItemModifyGwtSerDer()).serialize( o.modify ));
		}
		if (!childPropertiesToIgnore.contains("delete")) {
			ret.put("delete",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoChangesItemDeleteGwtSerDer()).serialize( o.delete ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}