/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.todolist.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class TodoListsVTodoQueryGwtSerDer implements GwtSerDer<net.bluemind.todolist.api.TodoListsVTodoQuery> {

	public TodoListsVTodoQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.todolist.api.TodoListsVTodoQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.todolist.api.TodoListsVTodoQuery ret = new net.bluemind.todolist.api.TodoListsVTodoQuery();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.todolist.api.TodoListsVTodoQuery ret, JSONObject json) {
		JSONValue ownerJSON = json.get("owner");
		ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		JSONValue containersJSON = json.get("containers");
		ret.containers =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(containersJSON);
		JSONValue vtodoQueryJSON = json.get("vtodoQuery");
		ret.vtodoQuery =  new net.bluemind.todolist.api.gwt.serder.VTodoQueryGwtSerDer().deserialize(vtodoQueryJSON);
	}

	public void deserializeTo(net.bluemind.todolist.api.TodoListsVTodoQuery ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("owner")) {
			JSONValue ownerJSON = json.get("owner");
			ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		}
		if (!childPropertiesToIgnore.contains("containers")) {
			JSONValue containersJSON = json.get("containers");
			ret.containers =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(containersJSON);
		}
		if (!childPropertiesToIgnore.contains("vtodoQuery")) {
			JSONValue vtodoQueryJSON = json.get("vtodoQuery");
			ret.vtodoQuery =  new net.bluemind.todolist.api.gwt.serder.VTodoQueryGwtSerDer().deserialize(vtodoQueryJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.todolist.api.TodoListsVTodoQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.todolist.api.TodoListsVTodoQuery o, JSONObject ret) {

		ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		ret.put("containers",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.containers ));
		ret.put("vtodoQuery",  new net.bluemind.todolist.api.gwt.serder.VTodoQueryGwtSerDer().serialize( o.vtodoQuery ));
	}

	public void serializeTo(net.bluemind.todolist.api.TodoListsVTodoQuery o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("owner")) {
			ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		}
		if (!childPropertiesToIgnore.contains("containers")) {
			ret.put("containers",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.containers ));
		}
		if (!childPropertiesToIgnore.contains("vtodoQuery")) {
			ret.put("vtodoQuery",  new net.bluemind.todolist.api.gwt.serder.VTodoQueryGwtSerDer().serialize( o.vtodoQuery ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}