/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.todolist.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class TodoListEndpointPromise implements net.bluemind.todolist.api.ITodoListPromise {

	private net.bluemind.todolist.api.ITodoListAsync impl;

	public TodoListEndpointPromise(net.bluemind.todolist.api.ITodoListAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> all() {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.all( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> allUids() {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allUids( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> changeset(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changeset(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> changesetById(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changesetById(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> copy(List<String> uids ,  String destContainerUid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.copy(uids, destContainerUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Count> count(net.bluemind.core.container.model.ItemFlagFilter arg0  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Count> ret = new CompletableFuture<net.bluemind.core.container.api.Count>();
		AsyncHandler<net.bluemind.core.container.api.Count> handler = new AsyncHandler<net.bluemind.core.container.api.Count>() {
			public void success(net.bluemind.core.container.api.Count value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.count(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.todolist.api.VTodo todo  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, todo,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> createById(long id ,  net.bluemind.todolist.api.VTodo arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.createById(id, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deleteById(long id  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteById(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(Long since ,  net.bluemind.core.container.model.ItemFlagFilter arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.filteredChangesetById(since, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> getByIcsUid(String uid  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getByIcsUid(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> getCompleteById(long id  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getCompleteById(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Long> getVersion() {
		
		CompletableFuture<Long> ret = new CompletableFuture<Long>();
		AsyncHandler<Long> handler = new AsyncHandler<Long>() {
			public void success(Long value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getVersion( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(String uid ,  Long arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemChangelog> ret = new CompletableFuture<net.bluemind.core.container.model.ItemChangelog>();
		AsyncHandler<net.bluemind.core.container.model.ItemChangelog> handler = new AsyncHandler<net.bluemind.core.container.model.ItemChangelog>() {
			public void success(net.bluemind.core.container.model.ItemChangelog value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.itemChangelog(uid, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> move(List<String> uids ,  String destContainerUid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.move(uids, destContainerUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> multipleDeleteById(List<Long> arg0 ,  Boolean bypassDeletedItems  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleDeleteById(arg0, bypassDeletedItems,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> multipleGet(List<String> uids  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGet(uids,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> multipleGetById(List<Long> arg0  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGetById(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> reset() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.reset( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> search(net.bluemind.todolist.api.VTodoQuery query  ) {
		
		CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> ret = new CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>();
		AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> handler = new AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>() {
			public void success(net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.search(query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<Long>> sortedIds(net.bluemind.core.container.model.SortDescriptor arg0  ) {
		
		CompletableFuture<List<Long>> ret = new CompletableFuture<List<Long>>();
		AsyncHandler<List<Long>> handler = new AsyncHandler<List<Long>>() {
			public void success(List<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.sortedIds(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> sortedUids(net.bluemind.core.container.model.SortDescriptor arg0  ) {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.sortedUids(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> sync(Long since ,  net.bluemind.todolist.api.VTodoChanges changes  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.sync(since, changes,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.todolist.api.VTodo todo  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, todo,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> updateById(long id ,  net.bluemind.todolist.api.VTodo arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateById(id, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerUpdatesResult> updates(net.bluemind.todolist.api.VTodoChanges changes  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerUpdatesResult> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerUpdatesResult>();
		AsyncHandler<net.bluemind.core.container.model.ContainerUpdatesResult> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerUpdatesResult>() {
			public void success(net.bluemind.core.container.model.ContainerUpdatesResult value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updates(changes,  handler);
		return ret;
	}

}
