/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2023
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.resource.service.internal;

import java.util.ArrayList;
import java.util.List;

import net.bluemind.core.api.Email;
import net.bluemind.core.auditlogs.AuditLogUpdateStatus;
import net.bluemind.core.auditlogs.AuditLogUpdateStatus.MessageCriticity;
import net.bluemind.core.auditlogs.ContentElement;
import net.bluemind.core.auditlogs.ContentElement.ContentElementBuilder;
import net.bluemind.core.container.model.ChangeLogEntry.Type;
import net.bluemind.directory.service.AuditLogDirEntryMapper;
import net.bluemind.directory.service.DirEntryAndValue;
import net.bluemind.resource.api.ResourceDescriptor;

public class AuditLogDirEntryResourceMapper extends AuditLogDirEntryMapper<ResourceDescriptor> {

	@Override
	public ContentElement createContentElement(DirEntryAndValue<ResourceDescriptor> dirEntryAndValue, Type type) {
		ContentElementBuilder builder = super.createContentElementBuilder(dirEntryAndValue);
		builder.with(dirEntryAndValue.value.emails.stream().map(m -> m.toString()).toList());
		return builder.build();
	}

	@Override
	public AuditLogUpdateStatus createUpdateMessage(DirEntryAndValue<ResourceDescriptor> oldValue,
			DirEntryAndValue<ResourceDescriptor> newValue) throws Exception {
		StringBuilder sBuilder = new StringBuilder();
		AuditLogUpdateStatus auditLogUpdateStatus = new AuditLogUpdateStatus();
		if (!oldValue.entry.displayName.equals(newValue.entry.displayName)) {
			sBuilder.append("Changed displayname: '" + oldValue.entry.displayName + "' -> '"
					+ newValue.entry.displayName + "'" + CRLF);
		}
		if (!oldValue.entry.email.equals(newValue.entry.email)) {
			sBuilder.append("Changed email: '" + oldValue.entry.email + "' -> '" + newValue.entry.email + "'" + CRLF);
		}
		List<Email> oldMails = new ArrayList<Email>(oldValue.value.emails);
		List<Email> newMails = new ArrayList<Email>(newValue.value.emails);
		List<Email> removed = oldMails.stream().filter(e -> !newMails.contains(e)).toList();
		removed.forEach(r -> sBuilder.append("removed email: " + r + CRLF));

		List<Email> added = newMails.stream().filter(e -> !oldMails.contains(e)).toList();
		added.forEach(r -> sBuilder.append("added email: " + r + CRLF));

		String updateMessage = sBuilder.toString();
		auditLogUpdateStatus.updateMessage = updateMessage;
		if (updateMessage.isBlank()) {
			auditLogUpdateStatus.crit = MessageCriticity.MINOR;
		}
//		if (!oldValue.value.accountType.equals(newValue.value.accountType)) {
//			sBuilder.append(
//					"Changed account type: " + oldValue.value.accountType + " -> " + newValue.value.accountType);
//		}
		if (updateMessage.isBlank()) {
			auditLogUpdateStatus.crit = MessageCriticity.MINOR;
		}
		return auditLogUpdateStatus;
	}

}
