/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MessageBodyPartGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.MessageBody.Part> {

	public MessageBodyPartGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.MessageBody.Part deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.MessageBody.Part ret = new net.bluemind.backend.mail.api.MessageBody.Part();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageBody.Part ret, JSONObject json) {
		JSONValue mimeJSON = json.get("mime");
		ret.mime =  GwtSerDerUtils.STRING.deserialize(mimeJSON);
		JSONValue mimeParametersJSON = json.get("mimeParameters");
		ret.mimeParameters =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(mimeParametersJSON);
		JSONValue addressJSON = json.get("address");
		ret.address =  GwtSerDerUtils.STRING.deserialize(addressJSON);
		JSONValue encodingJSON = json.get("encoding");
		ret.encoding =  GwtSerDerUtils.STRING.deserialize(encodingJSON);
		JSONValue charsetJSON = json.get("charset");
		ret.charset =  GwtSerDerUtils.STRING.deserialize(charsetJSON);
		JSONValue fileNameJSON = json.get("fileName");
		ret.fileName =  GwtSerDerUtils.STRING.deserialize(fileNameJSON);
		JSONValue headersJSON = json.get("headers");
		ret.headers =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyHeaderGwtSerDer()).deserialize(headersJSON);
		JSONValue contentIdJSON = json.get("contentId");
		ret.contentId =  GwtSerDerUtils.STRING.deserialize(contentIdJSON);
		JSONValue hashJSON = json.get("hash");
		ret.hash =  GwtSerDerUtils.STRING.deserialize(hashJSON);
		JSONValue childrenJSON = json.get("children");
		ret.children =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyPartGwtSerDer()).deserialize(childrenJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		JSONValue dispositionTypeJSON = json.get("dispositionType");
		ret.dispositionType =  new net.bluemind.backend.mail.api.gwt.serder.DispositionTypeGwtSerDer().deserialize(dispositionTypeJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageBody.Part ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("mime")) {
			JSONValue mimeJSON = json.get("mime");
			ret.mime =  GwtSerDerUtils.STRING.deserialize(mimeJSON);
		}
		if (!childPropertiesToIgnore.contains("mimeParameters")) {
			JSONValue mimeParametersJSON = json.get("mimeParameters");
			ret.mimeParameters =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(mimeParametersJSON);
		}
		if (!childPropertiesToIgnore.contains("address")) {
			JSONValue addressJSON = json.get("address");
			ret.address =  GwtSerDerUtils.STRING.deserialize(addressJSON);
		}
		if (!childPropertiesToIgnore.contains("encoding")) {
			JSONValue encodingJSON = json.get("encoding");
			ret.encoding =  GwtSerDerUtils.STRING.deserialize(encodingJSON);
		}
		if (!childPropertiesToIgnore.contains("charset")) {
			JSONValue charsetJSON = json.get("charset");
			ret.charset =  GwtSerDerUtils.STRING.deserialize(charsetJSON);
		}
		if (!childPropertiesToIgnore.contains("fileName")) {
			JSONValue fileNameJSON = json.get("fileName");
			ret.fileName =  GwtSerDerUtils.STRING.deserialize(fileNameJSON);
		}
		if (!childPropertiesToIgnore.contains("headers")) {
			JSONValue headersJSON = json.get("headers");
			ret.headers =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyHeaderGwtSerDer()).deserialize(headersJSON);
		}
		if (!childPropertiesToIgnore.contains("contentId")) {
			JSONValue contentIdJSON = json.get("contentId");
			ret.contentId =  GwtSerDerUtils.STRING.deserialize(contentIdJSON);
		}
		if (!childPropertiesToIgnore.contains("hash")) {
			JSONValue hashJSON = json.get("hash");
			ret.hash =  GwtSerDerUtils.STRING.deserialize(hashJSON);
		}
		if (!childPropertiesToIgnore.contains("children")) {
			JSONValue childrenJSON = json.get("children");
			ret.children =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyPartGwtSerDer()).deserialize(childrenJSON);
		}
		if (!childPropertiesToIgnore.contains("size")) {
			JSONValue sizeJSON = json.get("size");
			ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		}
		if (!childPropertiesToIgnore.contains("dispositionType")) {
			JSONValue dispositionTypeJSON = json.get("dispositionType");
			ret.dispositionType =  new net.bluemind.backend.mail.api.gwt.serder.DispositionTypeGwtSerDer().deserialize(dispositionTypeJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.MessageBody.Part o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageBody.Part o, JSONObject ret) {

		ret.put("mime",  GwtSerDerUtils.STRING.serialize( o.mime ));
		ret.put("mimeParameters",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.mimeParameters ));
		ret.put("address",  GwtSerDerUtils.STRING.serialize( o.address ));
		ret.put("encoding",  GwtSerDerUtils.STRING.serialize( o.encoding ));
		ret.put("charset",  GwtSerDerUtils.STRING.serialize( o.charset ));
		ret.put("fileName",  GwtSerDerUtils.STRING.serialize( o.fileName ));
		ret.put("headers",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyHeaderGwtSerDer()).serialize( o.headers ));
		ret.put("contentId",  GwtSerDerUtils.STRING.serialize( o.contentId ));
		ret.put("hash",  GwtSerDerUtils.STRING.serialize( o.hash ));
		ret.put("children",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyPartGwtSerDer()).serialize( o.children ));
		ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		ret.put("dispositionType",  new net.bluemind.backend.mail.api.gwt.serder.DispositionTypeGwtSerDer().serialize( o.dispositionType ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageBody.Part o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("mime")) {
			ret.put("mime",  GwtSerDerUtils.STRING.serialize( o.mime ));
		}
		if (!childPropertiesToIgnore.contains("mimeParameters")) {
			ret.put("mimeParameters",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.mimeParameters ));
		}
		if (!childPropertiesToIgnore.contains("address")) {
			ret.put("address",  GwtSerDerUtils.STRING.serialize( o.address ));
		}
		if (!childPropertiesToIgnore.contains("encoding")) {
			ret.put("encoding",  GwtSerDerUtils.STRING.serialize( o.encoding ));
		}
		if (!childPropertiesToIgnore.contains("charset")) {
			ret.put("charset",  GwtSerDerUtils.STRING.serialize( o.charset ));
		}
		if (!childPropertiesToIgnore.contains("fileName")) {
			ret.put("fileName",  GwtSerDerUtils.STRING.serialize( o.fileName ));
		}
		if (!childPropertiesToIgnore.contains("headers")) {
			ret.put("headers",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyHeaderGwtSerDer()).serialize( o.headers ));
		}
		if (!childPropertiesToIgnore.contains("contentId")) {
			ret.put("contentId",  GwtSerDerUtils.STRING.serialize( o.contentId ));
		}
		if (!childPropertiesToIgnore.contains("hash")) {
			ret.put("hash",  GwtSerDerUtils.STRING.serialize( o.hash ));
		}
		if (!childPropertiesToIgnore.contains("children")) {
			ret.put("children",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyPartGwtSerDer()).serialize( o.children ));
		}
		if (!childPropertiesToIgnore.contains("size")) {
			ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		}
		if (!childPropertiesToIgnore.contains("dispositionType")) {
			ret.put("dispositionType",  new net.bluemind.backend.mail.api.gwt.serder.DispositionTypeGwtSerDer().serialize( o.dispositionType ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}