/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MessageBodyGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.MessageBody> {

	public MessageBodyGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.MessageBody deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.MessageBody ret = new net.bluemind.backend.mail.api.MessageBody();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageBody ret, JSONObject json) {
		JSONValue guidJSON = json.get("guid");
		ret.guid =  GwtSerDerUtils.STRING.deserialize(guidJSON);
		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		JSONValue smartAttachJSON = json.get("smartAttach");
		ret.smartAttach =  GwtSerDerUtils.BOOLEAN.deserialize(smartAttachJSON);
		JSONValue dateJSON = json.get("date");
		ret.date =  GwtSerDerUtils.DATE.deserialize(dateJSON);
		JSONValue createdJSON = json.get("created");
		ret.created =  GwtSerDerUtils.DATE.deserialize(createdJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		JSONValue headersJSON = json.get("headers");
		ret.headers =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyHeaderGwtSerDer()).deserialize(headersJSON);
		JSONValue recipientsJSON = json.get("recipients");
		ret.recipients =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyRecipientGwtSerDer()).deserialize(recipientsJSON);
		JSONValue messageIdJSON = json.get("messageId");
		ret.messageId =  GwtSerDerUtils.STRING.deserialize(messageIdJSON);
		JSONValue referencesJSON = json.get("references");
		ret.references =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(referencesJSON);
		JSONValue structureJSON = json.get("structure");
		ret.structure =  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyPartGwtSerDer().deserialize(structureJSON);
		JSONValue previewJSON = json.get("preview");
		ret.preview =  GwtSerDerUtils.STRING.deserialize(previewJSON);
		JSONValue bodyVersionJSON = json.get("bodyVersion");
		ret.bodyVersion =  GwtSerDerUtils.INT.deserialize(bodyVersionJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageBody ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("guid")) {
			JSONValue guidJSON = json.get("guid");
			ret.guid =  GwtSerDerUtils.STRING.deserialize(guidJSON);
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			JSONValue subjectJSON = json.get("subject");
			ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		}
		if (!childPropertiesToIgnore.contains("smartAttach")) {
			JSONValue smartAttachJSON = json.get("smartAttach");
			ret.smartAttach =  GwtSerDerUtils.BOOLEAN.deserialize(smartAttachJSON);
		}
		if (!childPropertiesToIgnore.contains("date")) {
			JSONValue dateJSON = json.get("date");
			ret.date =  GwtSerDerUtils.DATE.deserialize(dateJSON);
		}
		if (!childPropertiesToIgnore.contains("created")) {
			JSONValue createdJSON = json.get("created");
			ret.created =  GwtSerDerUtils.DATE.deserialize(createdJSON);
		}
		if (!childPropertiesToIgnore.contains("size")) {
			JSONValue sizeJSON = json.get("size");
			ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		}
		if (!childPropertiesToIgnore.contains("headers")) {
			JSONValue headersJSON = json.get("headers");
			ret.headers =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyHeaderGwtSerDer()).deserialize(headersJSON);
		}
		if (!childPropertiesToIgnore.contains("recipients")) {
			JSONValue recipientsJSON = json.get("recipients");
			ret.recipients =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyRecipientGwtSerDer()).deserialize(recipientsJSON);
		}
		if (!childPropertiesToIgnore.contains("messageId")) {
			JSONValue messageIdJSON = json.get("messageId");
			ret.messageId =  GwtSerDerUtils.STRING.deserialize(messageIdJSON);
		}
		if (!childPropertiesToIgnore.contains("references")) {
			JSONValue referencesJSON = json.get("references");
			ret.references =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(referencesJSON);
		}
		if (!childPropertiesToIgnore.contains("structure")) {
			JSONValue structureJSON = json.get("structure");
			ret.structure =  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyPartGwtSerDer().deserialize(structureJSON);
		}
		if (!childPropertiesToIgnore.contains("preview")) {
			JSONValue previewJSON = json.get("preview");
			ret.preview =  GwtSerDerUtils.STRING.deserialize(previewJSON);
		}
		if (!childPropertiesToIgnore.contains("bodyVersion")) {
			JSONValue bodyVersionJSON = json.get("bodyVersion");
			ret.bodyVersion =  GwtSerDerUtils.INT.deserialize(bodyVersionJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.MessageBody o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageBody o, JSONObject ret) {

		ret.put("guid",  GwtSerDerUtils.STRING.serialize( o.guid ));
		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		ret.put("smartAttach",  GwtSerDerUtils.BOOLEAN.serialize( o.smartAttach ));
		ret.put("date",  GwtSerDerUtils.DATE.serialize( o.date ));
		ret.put("created",  GwtSerDerUtils.DATE.serialize( o.created ));
		ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		ret.put("headers",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyHeaderGwtSerDer()).serialize( o.headers ));
		ret.put("recipients",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyRecipientGwtSerDer()).serialize( o.recipients ));
		ret.put("messageId",  GwtSerDerUtils.STRING.serialize( o.messageId ));
		ret.put("references",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.references ));
		ret.put("structure",  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyPartGwtSerDer().serialize( o.structure ));
		ret.put("preview",  GwtSerDerUtils.STRING.serialize( o.preview ));
		ret.put("bodyVersion",  GwtSerDerUtils.INT.serialize( o.bodyVersion ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageBody o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("guid")) {
			ret.put("guid",  GwtSerDerUtils.STRING.serialize( o.guid ));
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		}
		if (!childPropertiesToIgnore.contains("smartAttach")) {
			ret.put("smartAttach",  GwtSerDerUtils.BOOLEAN.serialize( o.smartAttach ));
		}
		if (!childPropertiesToIgnore.contains("date")) {
			ret.put("date",  GwtSerDerUtils.DATE.serialize( o.date ));
		}
		if (!childPropertiesToIgnore.contains("created")) {
			ret.put("created",  GwtSerDerUtils.DATE.serialize( o.created ));
		}
		if (!childPropertiesToIgnore.contains("size")) {
			ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		}
		if (!childPropertiesToIgnore.contains("headers")) {
			ret.put("headers",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyHeaderGwtSerDer()).serialize( o.headers ));
		}
		if (!childPropertiesToIgnore.contains("recipients")) {
			ret.put("recipients",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.MessageBodyRecipientGwtSerDer()).serialize( o.recipients ));
		}
		if (!childPropertiesToIgnore.contains("messageId")) {
			ret.put("messageId",  GwtSerDerUtils.STRING.serialize( o.messageId ));
		}
		if (!childPropertiesToIgnore.contains("references")) {
			ret.put("references",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.references ));
		}
		if (!childPropertiesToIgnore.contains("structure")) {
			ret.put("structure",  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyPartGwtSerDer().serialize( o.structure ));
		}
		if (!childPropertiesToIgnore.contains("preview")) {
			ret.put("preview",  GwtSerDerUtils.STRING.serialize( o.preview ));
		}
		if (!childPropertiesToIgnore.contains("bodyVersion")) {
			ret.put("bodyVersion",  GwtSerDerUtils.INT.serialize( o.bodyVersion ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}