/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class FolderCountersGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.FolderCounters> {

	public FolderCountersGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.FolderCounters deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.FolderCounters ret = new net.bluemind.backend.mail.api.FolderCounters();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.FolderCounters ret, JSONObject json) {
		JSONValue itemIdJSON = json.get("itemId");
		ret.itemId =  GwtSerDerUtils.LONG.deserialize(itemIdJSON);
		JSONValue recordsVersionJSON = json.get("recordsVersion");
		ret.recordsVersion =  GwtSerDerUtils.LONG.deserialize(recordsVersionJSON);
		JSONValue unseenVisibleJSON = json.get("unseenVisible");
		ret.unseenVisible =  GwtSerDerUtils.INT.deserialize(unseenVisibleJSON);
		JSONValue totalVisibleJSON = json.get("totalVisible");
		ret.totalVisible =  GwtSerDerUtils.INT.deserialize(totalVisibleJSON);
		JSONValue totalJSON = json.get("total");
		ret.total =  GwtSerDerUtils.INT.deserialize(totalJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.FolderCounters ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("itemId")) {
			JSONValue itemIdJSON = json.get("itemId");
			ret.itemId =  GwtSerDerUtils.LONG.deserialize(itemIdJSON);
		}
		if (!childPropertiesToIgnore.contains("recordsVersion")) {
			JSONValue recordsVersionJSON = json.get("recordsVersion");
			ret.recordsVersion =  GwtSerDerUtils.LONG.deserialize(recordsVersionJSON);
		}
		if (!childPropertiesToIgnore.contains("unseenVisible")) {
			JSONValue unseenVisibleJSON = json.get("unseenVisible");
			ret.unseenVisible =  GwtSerDerUtils.INT.deserialize(unseenVisibleJSON);
		}
		if (!childPropertiesToIgnore.contains("totalVisible")) {
			JSONValue totalVisibleJSON = json.get("totalVisible");
			ret.totalVisible =  GwtSerDerUtils.INT.deserialize(totalVisibleJSON);
		}
		if (!childPropertiesToIgnore.contains("total")) {
			JSONValue totalJSON = json.get("total");
			ret.total =  GwtSerDerUtils.INT.deserialize(totalJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.FolderCounters o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.FolderCounters o, JSONObject ret) {

		ret.put("itemId",  GwtSerDerUtils.LONG.serialize( o.itemId ));
		ret.put("recordsVersion",  GwtSerDerUtils.LONG.serialize( o.recordsVersion ));
		ret.put("unseenVisible",  GwtSerDerUtils.INT.serialize( o.unseenVisible ));
		ret.put("totalVisible",  GwtSerDerUtils.INT.serialize( o.totalVisible ));
		ret.put("total",  GwtSerDerUtils.INT.serialize( o.total ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.FolderCounters o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("itemId")) {
			ret.put("itemId",  GwtSerDerUtils.LONG.serialize( o.itemId ));
		}
		if (!childPropertiesToIgnore.contains("recordsVersion")) {
			ret.put("recordsVersion",  GwtSerDerUtils.LONG.serialize( o.recordsVersion ));
		}
		if (!childPropertiesToIgnore.contains("unseenVisible")) {
			ret.put("unseenVisible",  GwtSerDerUtils.INT.serialize( o.unseenVisible ));
		}
		if (!childPropertiesToIgnore.contains("totalVisible")) {
			ret.put("totalVisible",  GwtSerDerUtils.INT.serialize( o.totalVisible ));
		}
		if (!childPropertiesToIgnore.contains("total")) {
			ret.put("total",  GwtSerDerUtils.INT.serialize( o.total ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}