/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class ReadOnlyMailboxFoldersEndpointPromise implements net.bluemind.backend.mail.api.IReadOnlyMailboxFoldersPromise {

	private net.bluemind.backend.mail.api.IReadOnlyMailboxFoldersAsync impl;

	public ReadOnlyMailboxFoldersEndpointPromise(net.bluemind.backend.mail.api.IReadOnlyMailboxFoldersAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> all() {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.all( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> byName(String name  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byName(name,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> changeset(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changeset(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> changesetById(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changesetById(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> childrensOf(String folderUid  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.childrensOf(folderUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(Long since ,  net.bluemind.core.container.model.ItemFlagFilter arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.filteredChangesetById(since, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<String> getFullName(String uid  ) {
		
		CompletableFuture<String> ret = new CompletableFuture<String>();
		AsyncHandler<String> handler = new AsyncHandler<String>() {
			public void success(String value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getFullName(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Long> getVersion() {
		
		CompletableFuture<Long> ret = new CompletableFuture<Long>();
		AsyncHandler<Long> handler = new AsyncHandler<Long>() {
			public void success(Long value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getVersion( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(String uid ,  Long arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemChangelog> ret = new CompletableFuture<net.bluemind.core.container.model.ItemChangelog>();
		AsyncHandler<net.bluemind.core.container.model.ItemChangelog> handler = new AsyncHandler<net.bluemind.core.container.model.ItemChangelog>() {
			public void success(net.bluemind.core.container.model.ItemChangelog value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.itemChangelog(uid, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> root() {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.root( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.backend.mail.api.SearchResult> searchItems(net.bluemind.backend.mail.api.MailboxFolderSearchQuery query  ) {
		
		CompletableFuture<net.bluemind.backend.mail.api.SearchResult> ret = new CompletableFuture<net.bluemind.backend.mail.api.SearchResult>();
		AsyncHandler<net.bluemind.backend.mail.api.SearchResult> handler = new AsyncHandler<net.bluemind.backend.mail.api.SearchResult>() {
			public void success(net.bluemind.backend.mail.api.SearchResult value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.searchItems(query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> trash() {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxFolder> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.trash( handler);
		return ret;
	}

}
