/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class MailConversationActionsSockJsEndpoint implements net.bluemind.backend.mail.api.IMailConversationActionsAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public MailConversationActionsSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/mail_conversation/{conversationContainer}/{replicatedMailboxUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{conversationContainer}", URL.encodePathSegment(pathVars[0]));
				uri_ = uri_.replace("{replicatedMailboxUid}", URL.encodePathSegment(pathVars[1]));
		
		baseUri = uri_;
	}

	public MailConversationActionsSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void addFlag(net.bluemind.backend.mail.api.flags.ConversationFlagUpdate flagUpdate, final AsyncHandler<net.bluemind.core.container.api.Ack> handler) {
		String postUri = "/_addFlag";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.backend.mail.api.flags.gwt.serder.ConversationFlagUpdateGwtSerDer().serialize( flagUpdate);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.api.Ack>(handler) {
					@Override
			protected net.bluemind.core.container.api.Ack handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.AckGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void copy(String targetMailboxUid, List<String> conversationUids, final AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>> handler) {
		String postUri = "/copy/{targetMailboxUid}";

		postUri = postUri.replace("{targetMailboxUid}", URL.encodePathSegment(""+targetMailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( conversationUids);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemIdentifier>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemIdentifier> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void deleteFlag(net.bluemind.backend.mail.api.flags.ConversationFlagUpdate flagUpdate, final AsyncHandler<net.bluemind.core.container.api.Ack> handler) {
		String postUri = "/_deleteFlag";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.backend.mail.api.flags.gwt.serder.ConversationFlagUpdateGwtSerDer().serialize( flagUpdate);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.container.api.Ack>(handler) {
					@Override
			protected net.bluemind.core.container.api.Ack handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.AckGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void importItems(long folderDestinationId, net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet mailboxItems, final AsyncHandler<net.bluemind.backend.mail.api.ImportMailboxItemsStatus> handler) {
		String postUri = "/importItems/{folderDestinationId}";

		postUri = postUri.replace("{folderDestinationId}", URL.encodePathSegment(""+folderDestinationId));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.backend.mail.api.flags.gwt.serder.ImportMailboxConversationSetGwtSerDer().serialize( mailboxItems);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.backend.mail.api.ImportMailboxItemsStatus>(handler) {
					@Override
			protected net.bluemind.backend.mail.api.ImportMailboxItemsStatus handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.backend.mail.api.gwt.serder.ImportMailboxItemsStatusGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void move(String targetMailboxUid, List<String> conversationUids, final AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>> handler) {
		String postUri = "/move/{targetMailboxUid}";

		postUri = postUri.replace("{targetMailboxUid}", URL.encodePathSegment(""+targetMailboxUid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( conversationUids);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemIdentifier>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemIdentifier> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void multipleDeleteById(List<String> conversationUids, final AsyncHandler<Void> handler) {
		String postUri = "/_multipleDelete";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( conversationUids);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}

	public net.bluemind.backend.mail.api.IMailConversationActionsPromise promiseApi() {
		return new MailConversationActionsEndpointPromise(this);
	}

}
