/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.system.cql.store;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.cql.persistence.CqlAbstractStore;
import net.bluemind.system.repository.ISystemConfStore;

public class CqlSystemConfStore extends CqlAbstractStore implements ISystemConfStore {

	public CqlSystemConfStore(CqlSession s) {
		super(s);
	}

	@Override
	public Map<String, String> get() {
		return Optional
				.ofNullable(unique("SELECT conf FROM t_system_conf WHERE conf_id=?",
						r -> r.getMap(0, String.class, String.class), voidPop(), ISystemConfStore.GLOBAL_ID))
				.orElse(Collections.emptyMap());
	}

	@Override
	public void update(Map<String, String> mutations) {
		voidCql("UPDATE t_system_conf SET conf = conf + ? WHERE conf_id=?", mutations, ISystemConfStore.GLOBAL_ID);
	}

}
