/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General  License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.repository;

import java.sql.SQLException;
import java.time.Instant;
import java.util.List;

import net.bluemind.backend.mail.api.MessageBody;
import net.bluemind.core.api.fault.ServerFault;

public interface IMessageBodyStore {

	int store(MessageBody value) throws SQLException;

	default int delete(String guid) throws SQLException {
		throw new ServerFault("NO: delete is handled by deleteOrphanBodies()");
	}

	MessageBody get(String guid) throws SQLException;

	default List<MessageBody> multiple(String... guids) throws SQLException {
		return multiple(List.of(guids));
	}

	List<MessageBody> multiple(List<String> guids) throws SQLException;

	boolean exists(String uid) throws SQLException;

	List<String> existing(List<String> toCheck) throws SQLException;

	List<String> deleteOrphanBodies() throws SQLException;

	List<String> deletePurgedBodies(Instant removedBefore, long limit) throws SQLException;

	void deleteNoRecordNoPurgeOrphanBodies() throws SQLException;

}
