import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './UserExternalAccountClient.json';

export class UserExternalAccountClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, domain , uid , base = '') {
        super(apiKey, base + '/api/users/{domain}/{uid}/accounts');
        this.domain = domain;
        this.base = this.base.replace('{domain}', encodeURIComponent(domain));
        this.uid = uid;
        this.base = this.base.replace('{uid}', encodeURIComponent(uid));
    }
    async create(system, account,  __fetchOptions = {}) {
        let __path = this.base + '/{system}';
        __path = __path.replace('{system}', encodeURIComponent(system));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (account != null) {
            __options.body = JSON.stringify(account);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(system,  __fetchOptions = {}) {
        let __path = this.base + '/{system}';
        __path = __path.replace('{system}', encodeURIComponent(system));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async deleteAll( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async get(system,  __fetchOptions = {}) {
        let __path = this.base + '/{system}';
        __path = __path.replace('{system}', encodeURIComponent(system));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getAll( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async update(system, account,  __fetchOptions = {}) {
        let __path = this.base + '/{system}';
        __path = __path.replace('{system}', encodeURIComponent(system));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (account != null) {
            __options.body = JSON.stringify(account);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
