
import { Tag } from "./Tag"; 
/**
 * This class is used to batch updates of a set of {@link Tag} using
 * {@link ITags#updates(TagChanges)}
 */
export type TagChanges = {
    /**
     * updated items
     */
    add?: Array<TagChanges.ItemAdd>;
    /**
     * modified items
     */
    modify?: Array<TagChanges.ItemModify>;
    /**
     * deleted items
     */
    delete?: Array<TagChanges.ItemDelete>;
};
export namespace TagChanges {
    export type ItemDelete = {
        uid?: string;
    };
    export type ItemModify = {
        uid?: string;
        value?: Tag;
    };
    export type ItemAdd = {
        uid?: string;
        value?: Tag;
    };

}
