import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './ServerClient.json';

export class ServerClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/servers/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async allComplete( __fetchOptions = {}) {
        let __path = this.base + '/_complete';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async assign(serverUid, domainUid, tag,  __fetchOptions = {}) {
        let __path = this.base + '/{domainUid}/assignments/{serverUid}/_assign';
        __path = __path.replace('{serverUid}', encodeURIComponent(serverUid));
        __path = __path.replace('{domainUid}', encodeURIComponent(domainUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (tag != null) {
            __url.searchParams.append("tag", tag);
        }
		return this.__fetchVoid(__url, __options);
    }
    async byAssignment(domainUid, tag,  __fetchOptions = {}) {
        let __path = this.base + '/{domainUid}/byAssignment';
        __path = __path.replace('{domainUid}', encodeURIComponent(domainUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (tag != null) {
            __url.searchParams.append("tag", tag);
        }
		return this.__fetchContent(__url, __options);
    }
    async create(uid, srv,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (srv != null) {
            __options.body = JSON.stringify(srv);
        }
		return this.__fetchContent(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async getAssignments(domainUid,  __fetchOptions = {}) {
        let __path = this.base + '/{domainUid}/assignments';
        __path = __path.replace('{domainUid}', encodeURIComponent(domainUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/complete';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getServerAssignments(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/serverAssignments';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getStatus(uid, ref,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/command_status';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (ref != null) {
            __url.searchParams.append("ref", ref);
        }
		return this.__fetchContent(__url, __options);
    }
    async readFile(uid, path,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/fs/{path}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        __path = __path.replace('{path}', encodeURIComponent(path));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async setTags(uid, tags,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/tags';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (tags != null) {
            __options.body = JSON.stringify(tags);
        }
		return this.__fetchContent(__url, __options);
    }
    async submit(uid, argv,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/submit_command';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (argv != null) {
            __options.body = JSON.stringify(argv);
        }
		return this.__fetchContent(__url, __options);
    }
    async submitAndWait(uid, argv,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/submit_command_and_wait';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (argv != null) {
            __options.body = JSON.stringify(argv);
        }
		return this.__fetchContent(__url, __options);
    }
    async unassign(serverUid, domainUid, tag,  __fetchOptions = {}) {
        let __path = this.base + '/{domainUid}/assignments/{serverUid}/_unassign';
        __path = __path.replace('{serverUid}', encodeURIComponent(serverUid));
        __path = __path.replace('{domainUid}', encodeURIComponent(domainUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (tag != null) {
            __url.searchParams.append("tag", tag);
        }
		return this.__fetchVoid(__url, __options);
    }
    async update(uid, srv,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (srv != null) {
            __options.body = JSON.stringify(srv);
        }
		return this.__fetchContent(__url, __options);
    }
    async writeFile(uid, path, content,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/fs/{path}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        __path = __path.replace('{path}', encodeURIComponent(path));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (content != null) {
            __options.body = JSON.stringify(content);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
