
import { ResourceTypeDescriptor } from "./ResourceTypeDescriptor"; 
import { ResourceType } from "./ResourceType"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Resource types API. Allows you to categorize resources by type.
 * 
 * Resource types are part of a domain (and only one).
 */
export interface IResourceTypes {
    /**
     * Create a { @link ResourceTypeDescriptor }.
     * @param resourceTypeDescriptor { @link ResourceTypeDescriptor }
     */
    create(identifier: string, resourceTypeDescriptor?: ResourceTypeDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete an existing { @link ResourceTypeDescriptor }.
     * @param uid { @link ResourceTypeDescriptor } unique id
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Fetch a { @link ResourceTypeDescriptor }.
     * @param uid { @link ResourceTypeDescriptor } unique id
     * @returns { @link ResourceTypeDescriptor } or null if it does not exist
     */
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<ResourceTypeDescriptor>;
    /**
     * Fetch a { @link ResourceTypeDescriptor } icon.
     * @param uid { @link ResourceTypeDescriptor } unique id
     * @returns icon binary data (png format) or null if the { @link
     *         ResourceTypeDescriptor } does not exist
     */
    getIcon(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    /**
     * Fetch all resources types
     * @returns list of all { @link ResourceType }
     */
    getTypes( __fetchOptions?: RequestOptions): Promise<Array<ResourceType>>;
    /**
     * Set an icon to { @link ResourceTypeDescriptor }.
     * @param uid { @link ResourceTypeDescriptor } unique id
     * @param icon icon binary data (png format)
     */
    setIcon(uid: string, icon?: ArrayBuffer,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Modify an existing { @link ResourceTypeDescriptor }.
     * @param uid { @link ResourceTypeDescriptor } unique id
     * @param resourceTypeDescriptor updated { @link ResourceTypeDescriptor }
     */
    update(uid: string, resourceTypeDescriptor?: ResourceTypeDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class ResourceTypesClient extends ApiEndPoint implements IResourceTypes {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    create(identifier: string, resourceTypeDescriptor?: ResourceTypeDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<ResourceTypeDescriptor>;
    getIcon(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    getTypes( __fetchOptions?: RequestOptions): Promise<Array<ResourceType>>;
    setIcon(uid: string, icon?: ArrayBuffer,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, resourceTypeDescriptor?: ResourceTypeDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
