
export type ResourceTypeDescriptor = {
    /**
     * Name.
     */
    label?: string;
    /**
     * User defined extra properties for this resource type. Example: may define a
     * 'Quality definition' property for a 'Video projector' type.
     */
    properties?: Array<ResourceTypeDescriptor.Property>;
    /**
     * Templates keyed by language tags.<br>
     * A template uses {@link #properties} names as variables.<br>
     * <br>
     * Example: <i>This template uses the property WhiteBoard having the value
     * ${WhiteBoard} and the property Seats having the value ${Seats}.</i>
     * 
     * @see Locale#toLanguageTag()
     */
    templates?: Record<string, string>;
};
export namespace ResourceTypeDescriptor {
    export type Property = {
        /**
         * Property unique id
         */
        id?: string;
        /**
         * Property name
         */
        label?: string;
        /**
         * {@link Type}
         */
        type?: ResourceTypeDescriptor.Property.Type;
    };
    export namespace Property {
        export type Type =  "Number" |  "String" |  "Boolean";
        export const Type : {
            readonly Number: Type,
            readonly String: Type,
            readonly Boolean: Type
        };

    }

}
