
import { VNotesQuery } from "./VNotesQuery"; 
import { VNote } from "./VNote"; 
import { 
    ItemContainerValue,
    ContainerDescriptor
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Notes list management API. See {@link INoteUids} on how to create the unique
 * UIDs.
 */
export interface INotes {
    /**
     * Create a notes list container + auto-subscribe + set ALL necessary
     * Access-Control-List entries
     * @param uid Unique UID according to {@link INoteUids}
     * @param descriptor Notelist container
     */
    create(uid: string, descriptor?: ContainerDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete a Notelist container and all containing {@link VNote}s
     * @param uid Unique UID
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Returns a {@link ListResult} of {@link ItemValue}s containing {@link VNote}s
     * @param query {@link VNotesQuery}
     * @returns {@link ListResult} of {@link ItemValue}s containing {@link VNote}s
     */
    search(query?: VNotesQuery,  __fetchOptions?: RequestOptions): Promise<Array<ItemContainerValue<VNote>>>;
}

export declare class NotesClient extends ApiEndPoint implements INotes {
    constructor(apiKey: string, base?: string);
    create(uid: string, descriptor?: ContainerDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    search(query?: VNotesQuery,  __fetchOptions?: RequestOptions): Promise<Array<ItemContainerValue<VNote>>>;
    getMetadata(): EndPointMetadata;
}
