import { 
    ContainerChangeset,
    ItemFlagFilter,
    ItemValue,
    Ack,
    SortDescriptor,
    ContainerUpdatesResult,
    Count,
    ItemChangelog,
    ItemVersion
} from "@bluemind/core.container.api";

import { VNote } from "./VNote"; 
import { VNoteQuery } from "./VNoteQuery"; 
import { VNoteChanges } from "./VNoteChanges"; 
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Notes API. All methods work on Notes in a specific container identified by a
 * unique UID. Use {@link net.bluemind.core.container.api.IContainers#all} to
 * lookup all containers of specific type.
 */
export interface INote {
    /**
     * List all Notes of a container
     * @returns All {@link VNote} of the container
     */
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VNote>>>;
    /**
     * Retrieve all {@link VNote} UIDs of this user
     * @returns List of UIDs
     */
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    count(arg0?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<Count>;
    /**
     * Creates a new {@link VNote} entry.
     * @param uid Unique entry UID
     * @param note {@link VNote} values
     */
    create(uid: string, note?: VNote,  __fetchOptions?: RequestOptions): Promise<void>;
    createById(id: number, arg1?: VNote,  __fetchOptions?: RequestOptions): Promise<Ack>;
    /**
     * Delete a {@link VNote}
     * @param uid unique UID
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteById(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Export all {@link VNote} from a notes container as json stream (VNote)
     * 
     * @see https://tools.ietf.org/html/rfc5545#section-3.6.2.
     * @returns {@link net.bluemind.core.api.Stream} of VNote list.
     */
    exportAll( __fetchOptions?: RequestOptions): Promise<Blob>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    /**
     * Fetch a {@link VNote} by its unique UID
     * @param uid Unique entry UID
     * @returns {@link net.bluemind.core.container.model.ItemValue} containing a
     *         {@link VNote}
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<VNote>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<VNote>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    multipleDeleteById(arg0?: Array<number>, bypassDeletedItems?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Fetch multiple {@link VNote}s by their unique UIDs
     * @param uids list of unique UIDs
     * @returns list of {@link net.bluemind.core.container.model.ItemValue}s
     *         containing {@link VNote}s
     */
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VNote>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VNote>>>;
    /**
     * Delete all {@link VNote}s of this user
     */
    reset( __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Search {@link VNote}'s by {@link VNoteQuery}
     * @param query {@link VNoteQuery}
     * @returns {@link net.bluemind.core.api.ListResult} of the matching
     *         {@link net.bluemind.core.container.model.ItemValue}s containing a
     *         {@link VNote}
     */
    search(query?: VNoteQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VNote>>>;
    sortedIds(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    sortedUids(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Modifies an existing {@link VNote}.
     * @param uid Unique entry UID
     * @param note {@link VNote} values
     */
    update(uid: string, note?: VNote,  __fetchOptions?: RequestOptions): Promise<void>;
    updateById(id: number, arg1?: VNote,  __fetchOptions?: RequestOptions): Promise<Ack>;
    /**
     * Updates multiple {@link VNote}s.
     * @param changes {@link VNoteChanges} containing the requested updates
     * @returns {@link net.bluemind.core.container.model.ContainerUpdatesResult}
     */
    updates(changes?: VNoteChanges,  __fetchOptions?: RequestOptions): Promise<ContainerUpdatesResult>;
}

export declare class NoteClient extends ApiEndPoint implements INote {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VNote>>>;
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    count(arg0?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<Count>;
    create(uid: string, note?: VNote,  __fetchOptions?: RequestOptions): Promise<void>;
    createById(id: number, arg1?: VNote,  __fetchOptions?: RequestOptions): Promise<Ack>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteById(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    exportAll( __fetchOptions?: RequestOptions): Promise<Blob>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<VNote>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<VNote>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    multipleDeleteById(arg0?: Array<number>, bypassDeletedItems?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VNote>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VNote>>>;
    reset( __fetchOptions?: RequestOptions): Promise<void>;
    search(query?: VNoteQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VNote>>>;
    sortedIds(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    sortedUids(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    update(uid: string, note?: VNote,  __fetchOptions?: RequestOptions): Promise<void>;
    updateById(id: number, arg1?: VNote,  __fetchOptions?: RequestOptions): Promise<Ack>;
    updates(changes?: VNoteChanges,  __fetchOptions?: RequestOptions): Promise<ContainerUpdatesResult>;
    getMetadata(): EndPointMetadata;
}
