
import { MailFilterRuleAction } from "./MailFilterRuleAction"; 
import { MailFilterRuleCondition } from "./MailFilterRuleCondition"; 
export type MailFilterRule = {
    id?: number;
    client?: string;
    type?: MailFilterRule.Type;
    trigger?: MailFilterRule.Trigger;
    deferred?: boolean;
    active?: boolean;
    name?: string;
    clientProperties?: Record<string, string>;
    conditions?: Array<MailFilterRuleCondition>;
    actions?: Array<MailFilterRuleAction>;
    stop?: boolean;
};
export namespace MailFilterRule {
    export type Type =  "GENERIC" |  "FORWARD" |  "VACATION";
    export const Type : {
        readonly GENERIC: Type,
        readonly FORWARD: Type,
        readonly VACATION: Type
    };
    export type Trigger =  "IN" |  "OUT";
    export const Trigger : {
        readonly IN: Trigger,
        readonly OUT: Trigger
    };

}
