import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './DomainsClient.json';

export class DomainsClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/domains');
    }
    async all( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async create(uid, domain,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (domain != null) {
            __options.body = JSON.stringify(domain);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async deleteDomainItems(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_items';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async findByNameOrAliases(name,  __fetchOptions = {}) {
        let __path = this.base + '/_lookup';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (name != null) {
            __url.searchParams.append("name", name);
        }
		return this.__fetchContent(__url, __options);
    }
    async get(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getExternalUrl(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/externalurl';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getRoles(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/roles';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async setAliases(uid, aliases,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_aliases';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (aliases != null) {
            __options.body = JSON.stringify(aliases);
        }
		return this.__fetchContent(__url, __options);
    }
    async setDefaultAlias(uid, defaultAlias,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_default_alias';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (defaultAlias != null) {
            __options.body = JSON.stringify(defaultAlias);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setRoles(uid, roles,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/roles';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (roles != null) {
            __options.body = JSON.stringify(roles);
        }
		return this.__fetchVoid(__url, __options);
    }
    async update(uid, domain,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (domain != null) {
            __options.body = JSON.stringify(domain);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
