import { 
    TaskRef
} from "@bluemind/core.task.api";

import { Domain } from "./Domain"; 
import { 
    ItemValue
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Manage domain.
 */
export interface IDomains {
    /**
     * Fetch all domains.
     * @returns a list of all {@link Domain}
     *         {@link net.bluemind.core.container.api.ItemValue} managed by the
     *         server
     */
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Domain>>>;
    /**
     * Creates a new {@link Domain}.
     * @param domain {@link Domain}
     */
    create(uid: string, domain?: Domain,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete the {@link Domain} item itself. You must call first deleteDomainItems
     * to delete domain's data. This operation is forbidden if there are still
     * linked data.
     * @param uid {@link Domain}'s unique id
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete data linked to the {@link Domain}. You must call this operation before
     * deleting the domain itself. According to the data quantity this operation can
     * be very long, you can follow its progression with the returned
     * {@link net.bluemind.core.task.api.TaskRef}.
     * @param uid {@link Domain}'s unique id
     * @returns a {@link net.bluemind.core.task.api.TaskRef} to track operation
     *         progress
     */
    deleteDomainItems(uid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Fetch a {@link Domain} by its name or one of its alias.
     * @param name {@link Domain}'s name or alias
     * @returns {@link Domain} {@link net.bluemind.core.container.api.ItemValue}, or
     *         null if no {@link Domain} match
     */
    findByNameOrAliases(name?: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Domain>>;
    /**
     * Fetch a {@link Domain} by its uid.
     * @param uid {@link Domain}'s unique id
     * @returns {@link Domain} {@link net.bluemind.core.container.api.ItemValue}, or
     *         null if the {@link Domain} does not exist
     */
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Domain>>;
    /**
     * Get effective domain external-url.
     * @returns domain external URL if defined, global external URL otherwisegitk
     */
    getExternalUrl(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getRoles(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Define domain aliases. If your domain already has aliases, you need to fetch
     * them first and then call this setAliases operation with all desired aliases.
     * @param uid {@link Domain}'s unique id
     * @param aliases set of aliases
     * @returns a {@link net.bluemind.core.task.api.TaskRef} to track operation
     *         progress
     */
    setAliases(uid: string, aliases?: Array<string>,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Define the domain default alias. The default alias is the name which appears
     * in the adminconsole when adding/modifying a domain "name". The default alias
     * is used as the default domain name to use when creating a new email account.
     * 
     * The default alias must be contained within the domain aliases.
     * @param uid {@link Domain}'s unique id
     * @param defaultAlias default domain name
     */
    setDefaultAlias(uid: string, defaultAlias?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    setRoles(uid: string, roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Modify an existing {@link Domain}.
     * @param uid {@link Domain}'s unique id
     * @param domain updated {@link Domain}
     */
    update(uid: string, domain?: Domain,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class DomainsClient extends ApiEndPoint implements IDomains {
    constructor(apiKey: string, base?: string);
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Domain>>>;
    create(uid: string, domain?: Domain,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteDomainItems(uid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    findByNameOrAliases(name?: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Domain>>;
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Domain>>;
    getExternalUrl(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getRoles(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    setAliases(uid: string, aliases?: Array<string>,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    setDefaultAlias(uid: string, defaultAlias?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    setRoles(uid: string, roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, domain?: Domain,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
