import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns specific document container UIDs.
 */
export interface IDocumentFolderUids {
    /**
     * Returns the default domain documentfolder UID
     * @param domain the {@link net.bluemind.domain.api.Domain}
     * @returns default domain documentfolder UID
     */
    documentFolderContainerUid(domain: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class DocumentFolderUidsClient extends ApiEndPoint implements IDocumentFolderUids {
    constructor(apiKey: string, base?: string);
    documentFolderContainerUid(domain: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
